#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Triangle dramaMod01.fsh   by  fyisic123
//https://www.shadertoy.com/view/Nt2cRV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Settings
#define Side_Distortion 27.
#define Zoom_Distortion_Frequency 8.
#define Zoom_Distortion_Amount 0.5
#define Zoom_Distortion_Speed 0.7
#define Tile_Count 5.
// ---Begin Common---//
#define PI 3.14159265359
#define hue(v) ( .6 + .6 * cos( 2.*PI*(v) + vec3(0,-2.*PI/3.,2.*PI/3.) ) )
mat2 Rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

float getRect(vec2 uv, float size)
{
    return sign(length(max(abs(uv)-size,0.0)));
}


float getStar(vec2 uv, float size)
{    
    float s = 0.5 * size;
    return (mod(getRect(uv, s ) + getRect(uv * Rot(radians(45.)), s), 2.)) ;
}


float XOR(float a, float b)
{
   return a*(1.-b) + b*(1. -a);
}
//----End Common----//


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    vec2 uv = (fragCoord.xy - .5 * iResolution.xy)/iResolution.y;
    
    
    float screenLength = length(uv);
    float uvDotP = dot(uv.x, uv.y);

    
    


    uv *=Rot(iTime *.025); // camera rotation
    uv *= Tile_Count;     
    uv+= vec2(sin(iTime*.03), cos(iTime*.02)) * 5.;  // camera drift
    
    vec2 gv = fract(uv) -.5;
    
    vec2 ID = floor(uv);
    
    if (mod(ID.x, 2.) == 0.) // flip uv for mirrored effect
        gv.x *= -1.;
        
    if (mod(ID.y, 2.) == 0.)
        gv.y *= -1.;

       
    
    
    gv *= (Rot(uvDotP *  pow(screenLength, 3.) *  Side_Distortion)); //  side distortion
    gv *= 1.0 + (Zoom_Distortion_Amount * sin(Zoom_Distortion_Frequency * screenLength + (iTime * Zoom_Distortion_Speed))); // zoom distortion

    vec2 offs = vec2(cos(iTime * 0.123) * cos( iTime), sin(iTime * 0.5))*(0.6*abs(sin(iTime * 0.2))); // Some movement
    
    float p = 0.;
    
        
    for(float i=1.; i > 0.; i -= 0.1)  // Get triangles
    {                        
        vec2 pos= gv + offs;
        p = XOR(p,(getStar(pos *Rot (i + iTime * 0.23), i )* pow(smoothstep(0.0, 1., length(pos)), 1.2)));        
         gv *= Rot( 0.4448 * sin( iTime * 0.1));//RM;  // rotates 25 degrees
        
    }
     
    
    
    
    fragColor = vec4(hue(atan(gv.x, gv.y)*p)  * p,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

